using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 2)
    {
      Console.WriteLine("Wywoanie programu: Program katalog wzorzec");
      return;
    }
    String katalog = args[0];
    String wzorzec = args[1];

    DirectoryInfo di = new DirectoryInfo(katalog);

    if(!di.Exists)
    {
      Console.WriteLine("Brak dostpu do katalogu: {0}", katalog);
      return;
    }

    FileInfo[] pliki;
    try
    {
      pliki = di.GetFiles(wzorzec);
    }
    catch(Exception)
    {
      Console.WriteLine("Wzorzec {0} jest niepoprawny.", wzorzec);
      return;
    }
    Console.WriteLine("Pliki w katalogu {0} pasujce do wzorca {1}:",
      katalog, wzorzec);
    foreach(FileInfo nazwa in pliki)
    {
      Console.WriteLine(nazwa.Name);
    }
  }
}
